unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms,
  Menus, StdCtrls, cbClasses, CaptionButton, AppAutoRun,
  FormRoller, FormTopmost, FormTrayIcon, ExtCtrls;

type
  TMainForm = class(TForm)
    FormTopmost1: TFormTopmost;
    FormRoller1: TFormRoller;
    AppAutoRun1: TAppAutoRun;
    CaptionButton2: TCaptionButton;
    CaptionButton3: TCaptionButton;
    PopupMenu1: TPopupMenu;
    CurrentUserItem: TMenuItem;
    LocalMachineItem: TMenuItem;
    WinNTServiceItem: TMenuItem;
    GroupBox1: TGroupBox;
    CaptionButton5: TCaptionButton;
    GroupBox2: TGroupBox;
    AutoRunBox: TCheckBox;
    Label1: TLabel;
    RunOnceBox: TCheckBox;
    Label3: TLabel;
    CurrentUserBtn: TRadioButton;
    LocalMachineBtn: TRadioButton;
    WinNTServiceBtn: TRadioButton;
    ShowIconBox: TCheckBox;
    TrayImageList: TImageList;
    AnimateBox: TCheckBox;
    Label4: TLabel;
    Label5: TLabel;
    AnimateIntervalEdit: TEdit;
    MinimizeBox: TCheckBox;
    RestoreBox: TCheckBox;
    LeftPopupBox: TCheckBox;
    HideIconBox: TCheckBox;
    TrayPopupMenu: TPopupMenu;
    Restore1: TMenuItem;
    Minimize1: TMenuItem;
    N1: TMenuItem;
    Close1: TMenuItem;
    N2: TMenuItem;
    AutoRunItem: TMenuItem;
    TrayIcon1: TFormTrayIcon;
    GroupBox3: TGroupBox;
    AnimateFormRoller: TCheckBox;
    Label6: TLabel;
    InfoBalloonEnabledBox: TCheckBox;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label2: TLabel;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    Button1: TButton;
    Label11: TLabel;
    Label12: TLabel;
    TextEdit: TEdit;
    TitleEdit: TEdit;
    Label13: TLabel;
    IconBox: TComboBox;
    Bevel1: TBevel;
    procedure CaptionButton5Pressed(Sender: TObject);
    procedure CaptionButton5Released(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AutoRunBoxClick(Sender: TObject);
    procedure AppAutoRun1ButtonClick(Sender: TObject; AutoRun: Boolean);
    procedure RunOnceBoxClick(Sender: TObject);
    procedure ShowIconBoxClick(Sender: TObject);
    procedure AnimateBoxClick(Sender: TObject);
    procedure AnimateIntervalEditChange(Sender: TObject);
    procedure MinimizeBoxClick(Sender: TObject);
    procedure RestoreBoxClick(Sender: TObject);
    procedure LeftPopupBoxClick(Sender: TObject);
    procedure HideIconBoxClick(Sender: TObject);
    procedure TrayIcon1Restore(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure CaptionButton2Pressed(Sender: TObject);
    procedure CaptionButton2Released(Sender: TObject);
    procedure CurrentUserBtnClick(Sender: TObject);
    procedure CurrentUserItemClick(Sender: TObject);
    procedure AutoRunItemClick(Sender: TObject);
    procedure AppAutoRun1AutoRun(Sender: TObject);
    procedure AnimateFormRollerClick(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure InfoBalloonEnabledBoxClick(Sender: TObject);
    procedure TextEditChange(Sender: TObject);
    procedure TitleEditChange(Sender: TObject);
    procedure IconBoxChange(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.CaptionButton5Pressed(Sender: TObject);
begin
  CaptionButton5.BtnOrder := 3;
end;

procedure TMainForm.CaptionButton5Released(Sender: TObject);
begin
  CaptionButton5.BtnOrder := 7;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  AutoRunBox.Checked := AppAutoRun1.AutoRun;
  RunOnceBox.Checked := AppAutoRun1.RunOnce;
  CurrentUserBtn.Checked := AppAutoRun1.RunFor = rfCurrentUser;
  LocalMachineBtn.Checked := AppAutoRun1.RunFor = rfLocalMachine;
  WinNTServiceBtn.Checked := AppAutoRun1.RunFor = rfService;
  CurrentUserItem.Checked := CurrentUserBtn.Checked;
  LocalMachineItem.Checked := LocalMachineBtn.Checked;
  WinNTServiceItem.Checked := WinNTServiceBtn.Checked;

  with TrayIcon1 do
   begin
    ShowIconBox.Checked := TrayIcon1.Visible;
    AnimateBox.Checked := TrayIcon1.Animate;
    AnimateIntervalEdit.Text := IntToStr(TrayIcon1.AnimateInterval);

    with Win2kInfoBalloon do
     begin
      InfoBalloonEnabledBox.Checked := Enabled;
      TextEdit.Text := Text;
      TitleEdit.Text := Title;
      IconBox.ItemIndex := Byte(Icon);
     end;
   end;   
end;

procedure TMainForm.AutoRunBoxClick(Sender: TObject);
begin
  AppAutoRun1.AutoRun := AutoRunBox.Checked;
  AutoRunItem.Checked := AutoRunBox.Checked;
end;

procedure TMainForm.AutoRunItemClick(Sender: TObject);
begin
  AutoRunBox.Checked := not AutoRunBox.Checked;
  AutoRunBoxClick(Sender);
end;

procedure TMainForm.AppAutoRun1ButtonClick(Sender: TObject;
  AutoRun: Boolean);
begin
  AutoRunBox.Checked := AutoRun;
end;

procedure TMainForm.RunOnceBoxClick(Sender: TObject);
begin
  AppAutoRun1.RunOnce := RunOnceBox.Checked;
end;

procedure TMainForm.ShowIconBoxClick(Sender: TObject);
begin
  TrayIcon1.Visible := ShowIconBox.Checked;
end;

procedure TMainForm.HideIconBoxClick(Sender: TObject);
begin
  if HideIconBox.Checked then
    TrayIcon1.Options := TrayIcon1.Options + [oHideOnRestore]
  else
    TrayIcon1.Options := TrayIcon1.Options - [oHideOnRestore];
end;

procedure TMainForm.AnimateBoxClick(Sender: TObject);
begin
  TrayIcon1.Animate := AnimateBox.Checked;
end;

procedure TMainForm.AnimateIntervalEditChange(Sender: TObject);
begin
  TrayIcon1.AnimateInterval := StrToIntDef(AnimateIntervalEdit.Text, 0);
end;

procedure TMainForm.MinimizeBoxClick(Sender: TObject);
begin
  if MinimizeBox.Checked then
    TrayIcon1.Options := TrayIcon1.Options + [oMinimizeToTray]
  else
    TrayIcon1.Options := TrayIcon1.Options - [oMinimizeToTray];
end;

procedure TMainForm.RestoreBoxClick(Sender: TObject);
begin
  if RestoreBox.Checked then
    TrayIcon1.Options := TrayIcon1.Options + [oOneClickRestore]
  else
    TrayIcon1.Options := TrayIcon1.Options - [oOneClickRestore];
end;

procedure TMainForm.LeftPopupBoxClick(Sender: TObject);
begin
  if LeftPopupBox.Checked then
    TrayIcon1.Options := TrayIcon1.Options + [oShowMenuOnLeftClick]
  else
    TrayIcon1.Options := TrayIcon1.Options - [oShowMenuOnLeftClick];
end;

procedure TMainForm.TrayIcon1Restore(Sender: TObject);
begin
  FormCreate(nil);
end;

procedure TMainForm.Close1Click(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.CaptionButton2Pressed(Sender: TObject);
begin
  CaptionButton2.Sign := 'B';
end;

procedure TMainForm.CaptionButton2Released(Sender: TObject);
begin
  CaptionButton2.Sign := 'A';
end;

procedure TMainForm.CurrentUserBtnClick(Sender: TObject);
begin
  CurrentUserItem.Checked := CurrentUserBtn.Checked;
  LocalMachineItem.Checked := LocalMachineBtn.Checked;
  WinNTServiceItem.Checked := WinNTServiceBtn.Checked;
end;

procedure TMainForm.CurrentUserItemClick(Sender: TObject);
begin
  CurrentUserBtn.Checked := TMenuItem(Sender).Tag = 1;
  LocalMachineBtn.Checked := TMenuItem(Sender).Tag = 2;
  WinNTServiceBtn.Checked := TMenuItem(Sender).Tag = 3;

  CurrentUserBtnClick(nil);
end;

procedure TMainForm.AppAutoRun1AutoRun(Sender: TObject);
begin
  Application.MessageBox('OnAutoRun event occured', 'CaptionButtons demo', mb_Ok or mb_IconInformation);
end;

procedure TMainForm.AnimateFormRollerClick(Sender: TObject);
begin
  FormRoller1.Animate := AnimateFormRoller.Checked;
end;

procedure TMainForm.RadioButton1Click(Sender: TObject);
begin
  BorderStyle := bsSizeable;
end;

procedure TMainForm.RadioButton2Click(Sender: TObject);
begin
  BorderStyle := bsDialog;
end;

procedure TMainForm.InfoBalloonEnabledBoxClick(Sender: TObject);
begin
  TrayIcon1.Win2kInfoBalloon.Enabled := InfoBalloonEnabledBox.Checked;
end;

procedure TMainForm.TextEditChange(Sender: TObject);
begin
  TrayIcon1.Win2kInfoBalloon.Text := TextEdit.Text;
end;

procedure TMainForm.TitleEditChange(Sender: TObject);
begin
  TrayIcon1.Win2kInfoBalloon.Title := TitleEdit.Text;
end;

procedure TMainForm.IconBoxChange(Sender: TObject);
begin
  TrayIcon1.Win2kInfoBalloon.Icon := TWin2kInfoIcon(IconBox.ItemIndex);
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
  TrayIcon1.ShowInfoBalloon;
end;

end.
